define([
    'underscore',
    'jquery',
    'backbone',
    'marionette',
    'modules/appointments/appointments-module',
    'modules/new-appointment-request/views/common/scheduling-steps/heading-view',
    'modules/new-appointment-request/views/common/type-of-care/section-view',
    'text!modules/new-appointment-request/views/common/scheduling-steps/templates/step-region.html',
], function(_, $, Backbone, Mn, module, HeadingView, SectionView, template) {
    'use strict';


    /**
     * @class TypeOfCareLayoutView
     * @typedef {Backbone.View<Backbone.Model>}
     */
    var View = Mn.View.extend({
        template: _.template(template),

        regions: {
            heading: '.step-heading',
            section: '.step-section',
        },

        modelEvents: {'change:typeOfCare': 'setName'},

        initialize: function(options) {
            var promise = module.fetchClinicalServices();
            var onDone = _.bind(this.setCollection, this);
            this.googleAnalytics = options.googleAnalyticsProvider.getInstance();
            promise.done(onDone);
        },

        setCollection: function(collection) {
            this.collection = collection;
            if (this._isRendered) {
                this.showSectionView();
            }
        },

        onRender: function() {
            this.showHeading();
            if (this.collection) {
                this.showSectionView();
            }
        },

        // TODO this is going into the model
        getCareName: function() {
            var id = this.model.get('typeOfCare');
            var model = this.collection.get(id);
            if (model) {
                return model.get('name');
            }
            return '';
        },

        showHeading: function() {
            var region = this.getRegion('heading');
            var model = new Backbone.Model({
                title: View.TITLE,
                number: View.STEP_NUMBER,
                instructions: View.INSTRUCTIONS,
            });
            region.show(new HeadingView({model: model}));
        },

        showSectionView: function() {
            var region = this.getRegion('section');
            region.show(new SectionView({
                model: this.model,
                clinicalServices: this.collection,
            }));
        },

        setName: function() {
            var name = this.getCareName();
            this.model.set('appointmentType', name);

            this.googleAnalytics.gas('send', 'event', 'veteran-appointment', 'type-of-care-selected', name);
        },
    });

    View.TITLE = 'Type of Care';
    View.STEP_NUMBER = 1;

    // eslint-disable-next-line max-len
    View.INSTRUCTIONS = 'The VA Appointments app supports scheduling specific types of care. If you do not find the care you need, please contact your facility for assistance.';


    return View;
});
